<?php
/* --------------------------------------------------------------
 RouteRegistration.php 2021-09-02
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Bootstrapper;

use Gambio\Core\Application\Application;
use Gambio\Core\Application\Bootstrapper;
use Gambio\Core\Application\Routing\RouteCollector;
use RuntimeException;

/**
 * Class RouteRegistration
 *
 * @package Gambio\Admin\Application\Bootstrapper
 */
class RouteRegistration implements Bootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $routeCollector = $this->getRouteCollector($application);
        
        $this->registerFavoriteMenuRoutes($routeCollector);
        
        $pattern = dirname(__DIR__, 2) . '/Modules/*/routes.php';
        $files   = glob($pattern);
        
        foreach ($files as $file) {
            /** @noinspection PhpIncludeInspection */
            $registerCallback = require $file;
            if (is_callable($registerCallback)) {
                $registerCallback($routeCollector);
            }
        }
    }
    
    
    /**
     * @param Application $application
     *
     * @return RouteCollector
     */
    private function getRouteCollector(Application $application): RouteCollector
    {
        if (!$application->has(RouteCollector::class)) {
            throw new RuntimeException('RouteCollector must be registered before this bootstrapper ca be executed');
        }
        
        return $application->get(RouteCollector::class);
    }
    
    
    /**
     * @param RouteCollector $routeCollector
     *
     * @throws RuntimeException
     */
    private function registerFavoriteMenuRoutes(RouteCollector $routeCollector): void
    {
        $pattern = dirname(__DIR__, 2) . '/Layout/routes.php';
        $files   = glob($pattern);
        
        foreach ($files as $file) {
            /** @noinspection PhpIncludeInspection */
            if (!file_exists($file)) {
                throw new RuntimeException('Could not find file:' . $file);
            }
            $registerCallback = require $file;
            if (is_callable($registerCallback)) {
                $registerCallback($routeCollector);
            }
        }
    }
}